//
//  main.c
//  Pro
//    Works by reading in information from a file NO PIR
//  Created by Chris Ruff on 4/11/14.
//  Copyright (c) 2014 Chris Ruff. All rights reserved.
//

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <ifaddrs.h>
#include <errno.h>



struct timeval real_time;
struct timeval real_ticket_time;


#define file_read 2 // how often thread will read from the file to update information
#define MSG_SIZE 40			// message size
#define PARKING_METER_ID 2 // this is the id of the parking meter
#define DayilyLim  60
#define InputLim  10


typedef struct parking_struct
{
    int money_in; // how much money was added to add time to real time
    int end_program;  // how to know to end program
    int time_flag; // flag to know if time was addded
    long real_time; // amount of time on paid for
    int ticket_flag;  // 0 for no ticket 1 if ticket should be given
    int car_at_meter; // 0 no car 1 a car a meeter
    FILE* fp;  // file pointer

    int sock;
    int length;
    int error_message;
    int boolval;
    char message_to_send [35];
    char buffer[MSG_SIZE];	// to store received messages or messages to be sent.
    char message_to_server[5]; // will hold the message to send to server every few seconds

    // NEW FOR TCP
    int sockfd, portno;// n;
    struct sockaddr_in serv_addr;
    struct hostent *server;
    char *ip_server; // ip of server must be known before running clients


}parking_struct;


void error(const char *msg)
{
    perror(msg);
    exit(0);
}


void read_from_file (parking_struct *parking)
{ // reads information from file so that no user is needed.

    int temp_car;
    int temp_payment;

// from file    1 = 5 sec
//              2 = 10 sec
//              3 = 25 sec


    while ( fscanf( parking->fp, "%d %d" , &temp_car, &temp_payment) != EOF)
    {
    	
        printf(" Car at spot ( 0 -> NO, 1 -> YES ) : %d , Time for car: %d \n", temp_car, temp_payment);

        if ( temp_car == 1)
        {
            printf(" Yes, car at parking meter set to 1. Now check time paid \n");
            parking->car_at_meter = 1;// set to 1 since a car has been read from file

            if ( temp_payment >0)
            {
                printf(" Payment made by user update parking meter clock \n");
                parking->money_in = temp_payment;

            }
            else printf(" No payment made keep clock as it was \n");
        }
        else
        {
            printf(" No car at parking meter set to 0. Keep reading from file \n");
            parking->car_at_meter = 0;
        }


        sleep(2); // only read from the file every 10 seconds.
        printf("\n");




    }// end of the while

    printf("File empty stop program\n");
    //parking->money_in =0; // end progmra
    //parking->end_program =1; // end program


    /*
     int end_program;  // how to know to end program
     int time_flag; // flag to know if time was addded
     long real_time; // amount of time on paid for
     int ticket_flag;  // 0 for no ticket 1 if ticket should be given
     int car_at_meter; // 0 no car 1 a car a meeter

     */

    pthread_exit(0);
}




void ticket_pipe (parking_struct *parking)
{ // this thread will send info to sever every few seconds.
    // create message to send to server

    char random_buffer[3];

    // Message that will come in on buffer will be in this format - all ints.
    // Parking Meter Number, car at metter =1 no car = 0; if should ticket =1  else =0;

    // picture will be at the end in what ever format it needs to be
    //char* buff = "3 1 1"; example of what ever wants


    //printf("%s\n", parking->message_to_server);



    while (1)
    {

    
 		snprintf(random_buffer, sizeof(random_buffer), "%d ", PARKING_METER_ID);
    	strcpy(parking->message_to_server, random_buffer);


        if ( parking->ticket_flag == 1)
        {
				//printf("Write to sever that parking meter 1 has a car and needs a ticket\n");

				// write to server message should be 1 1 1
				// this is meter 1 with a car that needs a ticket
          snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->car_at_meter);
            strcat(parking->message_to_server, random_buffer);

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->ticket_flag);
            strcat(parking->message_to_server, random_buffer);

            printf("ticket\n");

            parking->ticket_flag = 0;

        }
        else if(parking->car_at_meter ==1)
        {
            //printf("Write to sever that parking meter 1 has a car and needs no ticket\n");

            // write to server message should be 1 1 0
            // this is meter 1 with a car that needs a ticket

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->car_at_meter);
            strcat(parking->message_to_server, random_buffer);

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->ticket_flag);
            strcat(parking->message_to_server, random_buffer);


        }
        else
        {
            //printf("Write to sever that parking meter 1 has no car and needs no ticket\n");

            // write to server message should be 1 0 0
            // this is meter 1 with a car that needs a ticket

            snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->car_at_meter);
                   strcat(parking->message_to_server, random_buffer);

                   snprintf(random_buffer, sizeof(random_buffer), "%d ", parking->ticket_flag);
                   strcat(parking->message_to_server, random_buffer);


        }
      //  printf("%s\n",parking->message_to_server);
        bzero(parking->buffer,MSG_SIZE);			// sets all values to zero. memset() could be used
        //printf(" Sockfd before%d\n", parking->sockfd);
        parking->sockfd = 4;
        //printf(" Sockfd After%d\n", parking->sockfd);

        parking->error_message = write(parking->sockfd,parking->message_to_server,strlen(parking->message_to_server)-1);
        if (parking->error_message < 0)
            error("ERROR writing to socket");




      	sleep(2);



    }// end of while (1) loop

    pthread_exit(0);
}





void pir (parking_struct *parking) // no longer needed in this program since information will come from a file.
{// dont need anymore
    //while (1)
    {

        //parking->car_at_meter = /// get data for PIR hardware
        //parking->car_at_meter = 1;

    }

    pthread_exit(0);
}


void ticket_time (parking_struct *parking)// one thread does everything for mult
{
    //int go =0;
    while (1)
    {

        gettimeofday(&real_ticket_time, NULL);
        if(parking->car_at_meter == 0)
        {

            parking->real_time = 0;
        }



        if ( parking->real_time == real_ticket_time.tv_sec)
        {
        	 fflush(stdout);
            printf( "Ticket needs to be given\n" );
            fflush(stdout);
            parking->ticket_flag = 1; // this flag will start the socket send
            parking->real_time = 0;

        }


        usleep(1);

    }//end of while

    pthread_exit(0);
}



void money (parking_struct *parking)
{ // takes money from users, this progmra will read it from the file.
    //fflush(stdout);

    //parking->money_in = 2;

   //while (parking->money_in != 0)
    while (1)
    {
        //while ( (parking->money_in > 1 || parking->money_in < 3) && parking->car_at_meter == 1)//change to work with file input
        if ( parking->car_at_meter == 1)
        {
           printf("car at meter\n");

            if ( parking->money_in == 1) // 5 sec
            {
                printf(" ! 1 !\n");
                if(parking->real_time == 0) // check to see if there is already time on meter
                {

                    gettimeofday(&real_time, NULL);
                    parking->real_time = real_time.tv_sec; // set new time to time
                     //printf("time = %lu\n", real_time.tv_sec);
                }


                parking->time_flag = 1; // set flag to know time was added to clock

                parking->real_time += 5; // add 5 secs to time one meter.
               // printf("time = %lu \n", parking->real_time);
                parking->money_in = 0; // reset to

            }
            //pthread_yield_np();

            else if (parking->money_in == 2) // 10 sec
            {
                printf(" ! 2 !\n");
                if(parking->real_time == 0)// check to see if there is already time on meter
                {

                    gettimeofday(&real_time, NULL);
                    parking->real_time = real_time.tv_sec;
                    //printf("time = %lu\n", real_time.tv_sec);
                }


                parking->time_flag = 1; // set flag to know time was added to clock

                //parking->time_to_sleep = parking->time_to_sleep + 10;

                parking->real_time += 10;
                //printf("time = %lu \n", parking->real_time);
               // sem_post(&semaphore_p);

                parking->money_in = 0;

            }

            else if (parking->money_in == 3) //25
            {
                printf(" ! 3 !\n");
                if(parking->real_time == 0)// check to see if there is already time on meter
                {

                    gettimeofday(&real_time, NULL);
                    parking->real_time = real_time.tv_sec;
                    //printf("time = %lu\n", real_time.tv_sec);
                }


                parking->time_flag = 1; // set flag to know time was added to clock

                //parking->time_to_sleep = parking->time_to_sleep + 25;

                parking->real_time += 25;
                //printf("time = %lu \n", parking->real_time);
                //sem_post(&semaphore_p);


                parking->money_in = 0;


            }



        }//end of if

        sleep(1);
    }// end of while (1)

    pthread_exit(0);
}




int main(int argc, const char * argv[])
{


     if (argc < 2) // add back in to have server port
      {
        printf("usage: %s Port which server is on, file to read ->test1.txt\n", argv[0]);
     	 exit(0);
     }


    parking_struct *parking = NULL;
    parking = malloc(sizeof(parking_struct));

    if ( parking == NULL )
    {
        printf("Malloc problem with parking mem");
        return 0;
    }

    //parking->fp =fopen("test1.txt", "r"); // change this to take in the arguments
    parking->fp =fopen(argv[2], "r");

    if(parking->fp == NULL)
    {
        printf("Problem no file\n");
        return 0;
    }
    else    printf("FILE is open\n");


    parking->money_in = 1;
    parking->real_time = 0;
    parking->ticket_flag =  0;
    parking->car_at_meter = 0;
    parking->boolval = 1;
    parking->ip_server = "10.3.52.17"; // ip of server must be known before running clients

    char hostn[400]; //placeholder for the hostname
       struct hostent *hostIP; //placeholder for the IP address

       //if the gethostname returns a name then the program will get the ip address using gethostbyname
       if((gethostname(hostn, sizeof(hostn))) == 0)
       {
           hostIP = gethostbyname(hostn); //the netdb.h function gethostbyname
           //printf("IP address: %s\n", inet_ntoa(*(struct in_addr*)hostIP->h_addr));
       }
       else
       {
           printf("ERROR:FC4539 - IP Address not found."); //error if thehostname is not found
       }


    parking->portno = atoi(argv[1]);		// port # was an input.
          parking->sockfd = socket(AF_INET, SOCK_STREAM, 0); // Creates socket. Connection based.

          if (parking->sockfd < 0)
              error("ERROR opening socket");

          parking->server = gethostbyname(parking->ip_server);  // converts hostname input (e.g. 10.3.52.255)
          if (parking->server == NULL)
          {
              fprintf(stderr,"ERROR, no such host\n");
              exit(0);
          }

          // fill in fields of serv_addr
              bzero((char *) &parking->serv_addr, sizeof(parking->serv_addr));	// sets all values to zero
              parking->serv_addr.sin_family = AF_INET;		// symbol constant for Internet domain

              // copy to serv_addr.sin_addr.s_addr. Function memcpy could be used instead.
              bcopy((char *)parking->server->h_addr, (char *)&parking->serv_addr.sin_addr.s_addr, parking->server->h_length);

              parking->serv_addr.sin_port = htons(parking->portno);		// fill sin_port field

              // establish connection to the server
              if (connect(parking->sockfd,(struct sockaddr *) &parking->serv_addr,sizeof(parking->serv_addr)) < 0)
                  error("ERROR connecting Check Sever IP");



    pthread_t money_input, time ,  pipe_ticket;
    pthread_t read_file;



    pthread_create(&read_file, NULL, (void*)&read_from_file, (void*)parking);  // reads information from a file

    pthread_create(&money_input, NULL, (void*)&money, (void*)parking);  // get money from user
    pthread_create(&time, NULL, (void*)&ticket_time, (void*)parking);   // check real time vs amount of time bought.
   // //pthread_create(&pir_hardware, NULL, (void*)&pir, (void*)parking);   // checks pir hardware if car is parked or not
    pthread_create(&pipe_ticket, NULL, (void*)&ticket_pipe, (void*)parking);    // send info on pipe for a ticket


    while (parking->money_in != 0)
    {


    }//end of while loop


    free(parking);


    return 0;
}

